import java.io.IOException;

public class CheckingAccount extends Account {
	
	private double interestRate = 0.00001;
	
	/**Constructor: creates a checking account with a balance and owner **/
	public CheckingAccount(double balance, Bank bank, Person p){
		super(balance, bank, p);
	}
	
	/**Pays money to a store by transferring money from your account **/
	public void payTo(Store s, double amt){
		try {
			if( getOwner().requestPassword()){
				Transfer.transfer(this, s.getOwner(), amt);
			}
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    }
	
	/**Pays money to a Person by transferring the money to the other party **/
	public void payTo(Person p, double amt){
		try {
			if( getOwner().requestPassword()){
				Transfer.transfer(this, p, amt);
			}
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    }
	
	/**Accessor: returns the interest rate **/
	public double getIR(){
		return interestRate;
	}
	
	/**Modifier: sets the interest rate to val **/
	public void setIR(double val){
		interestRate = val;
	}

}
